plugins {
    alias(libs.plugins.kotlin.multiplatform).apply(false)
    alias(libs.plugins.compose.compiler).apply(false)
    alias(libs.plugins.compose.multiplatform).apply(false)
    alias(libs.plugins.kotlin.android).apply(false)
    alias(libs.plugins.android.application).apply(false)
    alias(libs.plugins.android.kmp.library).apply(false)
    alias(libs.plugins.kotlin.jvm).apply(false)
    alias(libs.plugins.kotlinx.serialization).apply(false)
    alias(libs.plugins.buildConfig).apply(false)
}

val appName = "Theorycrafter"
extra["appName"] = appName

tasks.register("packageSource", Exec::class) {
    description = "Packages the source code into a zip file"
    group = "other"

    val outputFile = layout.projectDirectory.file("${appName}-src.zip")
    outputs.file(outputFile)

    val file = outputFile.asFile

    commandLine(
        "git",
        "archive",
        "--format=zip",
        "--output=${file.absolutePath}",
        "HEAD",
        ".", // Include everything
        // Exclude these
        ":(exclude)website",
        ":(exclude).git",
        ":(exclude)*.gitignore",
        ":(exclude)*.gitattributes",
        ":(exclude).github",
        ":(exclude).idea",
        ":(exclude)*.DS_Store",
    )
}